document.addEventListener("DOMContentLoaded", function () {
    // Content data for each page
    const pageData = {
        "beranda": {
            title: "Beranda",
            content: `
                <p>Selamat datang di website resmi Paroki Santa Maria Blitar. Di sini Anda dapat menemukan informasi terbaru tentang kegiatan gereja, jadwal misa, dan pengumuman penting.</p>
            `
        },
        "sekretariat-formulir": {
            title: "Formulir",
            content: `
                <p>Di sini Anda dapat mengunduh berbagai formulir yang diperlukan untuk keperluan administrasi gereja, seperti pendaftaran baptis, pernikahan, dan lainnya.</p>
            `
        },
        "sekretariat-pengumuman": {
            title: "Pengumuman",
            content: `
                <p>Temukan pengumuman terbaru dari sekretariat Paroki Santa Maria Blitar, termasuk informasi tentang acara, kegiatan, dan perubahan jadwal.</p>
            `
        },
        "sekretariat-fasilitas": {
            title: "Fasilitas",
            content: `
                <p>Paroki Santa Maria Blitar menyediakan berbagai fasilitas untuk mendukung kegiatan umat, seperti ruang pertemuan, perpustakaan, dan area parkir.</p>
            `
        },
        "sekretariat-tentang": {
            title: "Tentang Sekretariat",
            content: `
                <p>Sekretariat Paroki Santa Maria Blitar melayani umat dalam hal administrasi gereja, pendaftaran sakramen, dan informasi umum.</p>
            `
        },
        "pastoral-dpp-bgkp": {
            title: "DPP/BGKP",
            content: `
                <p>Dewan Paroki Pastoral (DPP) dan Badan Gereja Kategorial Paroki (BGKP) bekerja sama untuk mengkoordinasikan kegiatan pastoral di Paroki Santa Maria Blitar.</p>
            `
        },
        "pastoral-komisi": {
            title: "Komisi",
            content: `
                <p>Komisi-komisi di Paroki Santa Maria Blitar bertugas untuk mendukung berbagai aspek pelayanan, seperti liturgi, katekese, dan sosial.</p>
            `
        },
        "pastoral-kategorial": {
            title: "Kategorial",
            content: `
                <p>Kelompok kategorial di Paroki Santa Maria Blitar meliputi berbagai komunitas umat, seperti OMK, Legio Maria, dan kelompok doa.</p>
            `
        },
        "pastoral-lingkungan-stasi": {
            title: "Lingkungan/Stasi",
            content: `
                <p>Lingkungan dan stasi di Paroki Santa Maria Blitar merupakan komunitas kecil umat yang aktif dalam kegiatan rohani dan sosial.</p>
            `
        },
        "pastoral-romo-paroki": {
            title: "Romo Paroki",
            content: `
                <p>Romo Paroki Santa Maria Blitar memimpin umat dalam perjalanan iman, memberikan sakramen, dan menggembalakan jemaat.</p>
            `
        },
        "pastoral-biarawan-biarawati": {
            title: "Biarawan/Biarawati",
            content: `
                <p>Biarawan dan biarawati di Paroki Santa Maria Blitar turut membantu dalam pelayanan rohani dan sosial kepada umat.</p>
            `
        },
        "tentang-sejarah": {
            title: "Sejarah",
            content: `
                <p>Paroki Santa Maria Blitar didirikan pada tahun [tahun], dan telah menjadi pusat kegiatan rohani bagi umat Katolik di Blitar.</p>
            `
        },
        "tentang-peta-wilayah": {
            title: "Peta Wilayah",
            content: `
                <p>Lihat peta wilayah Paroki Santa Maria Blitar untuk mengetahui batas-batas paroki dan lokasi stasi-stasi yang ada.</p>
            `
        },
        "tentang-web": {
            title: "Tentang Web",
            content: `
                <p>Website ini dibuat untuk memudahkan umat mendapatkan informasi terbaru tentang Paroki Santa Maria Blitar.</p>
            `
        }
    };

    const artikelData = {
        "1": {
            title: "Title 1",
            content: "Ini adalah artikel lengkap pertama. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.",
            
        },
        "2": {
            title: "Title 2",
            content: "Ini adalah artikel lengkap kedua. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.",
            
        },
        "3": {
            title: "Title 3",
            content: "Ini adalah artikel lengkap ketiga. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.",
            
        },
        "4": {
            title: "Title 4",
            content: "Ini adalah artikel lengkap keempat. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.",
            
        },
        "5": {
            title: "Title 5",
            content: "Ini adalah artikel lengkap kelima. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.",
            
        },
        "6": {
            title: "Title 6",
            content: "Ini adalah artikel lengkap keenam. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.",
            
        }
    }

    
// Get the page and id parameters from the URL
const urlParams = new URLSearchParams(window.location.search);
const page = urlParams.get("page") || "beranda"; // Default to "beranda" if no page is specified
const articleId = String(urlParams.get("id"));

// Get the elements to update
const pageTitle = document.getElementById("page-title");
const pageContent = document.getElementById("page-content");

// Handle the "artikel" page
if (page === "artikel" && articleId && artikelData[articleId]) {
    pageTitle.textContent = artikelData[articleId].title;
    pageContent.innerHTML = artikelData[articleId].content;
} else if (pageData[page]) {
    // Handle other static pages
    pageTitle.textContent = pageData[page].title;
    pageContent.innerHTML = pageData[page].content;
} else {
    // Fallback if the page or article is not found
    pageTitle.textContent = "Halaman Tidak Ditemukan";
    pageContent.innerHTML = `<p>Maaf, halaman atau artikel yang Anda cari tidak ditemukan.</p>`;
}
});

